﻿/*
 * WebData
 * 
 * ver 2021.08.20
 *  
 * 新たにきどうした時は、上書き保存、復元時は新規保存
 * デ－タ復元を追加
 * TimerIntervalを変更可能とす
 * グラフのメモリを増やした
 * pictureBoxでデ－タのある所をクリックするとデ－タを表示
 * 
*/

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Net;
using System.IO;
using System.Net.NetworkInformation;

namespace webdata
{
    public partial class Form1 : Form
    {
        int DTotal = 1000;

        public struct WData
        {
            public String d;
            public float temp;
            public float hum;
            public float press;
        }
        public WData[]  WD= new WData[1001];
        public int appendFlg = 0;
        public int Ps,Pe, Pg= 0;
        public int Pw,Ph,Px,Px0,pr0=0;
        public float Pmax, Pmin, Tmax, Tmin, Hmax, Hmin;
        public String Pmaxtime,Pmintime,Tmaxtime, Tmintime,Hmaxtime,Hmintime;


        public String Hiniti, Ondo, Situdo, Kiatu;

        private void pictureBox1_MouseClick(object sender, MouseEventArgs e)
        {
            int len= textBox3.Lines.Length;
            int x = e.X - 50;

            if ((len==0)||(x>len)||(x<1))
                    return;
            
            label8.Text = textBox3.Lines[x];
        }



        public Bitmap canvas;
        public Form1()
        {
            InitializeComponent();
        }
        private void Form1_Load(object sender, EventArgs e)
        {
            Width = 1150;
            Height = 770;
            Ph = pictureBox1.Height;
            Pw = pictureBox1.Width;
            button1.Location = new Point(705, 39);
            button2.Location = new Point(1041, 39);
            button4.Location = new Point(932, 39);
            button5.Location = new Point(705, 78);
            label1.Location = new Point(12, 12);
            textBox2.Location = new Point(58, 10);

            textBox1.Location = new Point(58, 38);
            textBox3.Location = new Point(370, 38);
            textBox1.Size = new Size(310, 180);
            textBox3.Size = new Size(310, 180);

            textBox4.Location = new Point(685, 144);
            textBox5.Location = new Point(910, 144);
            textBox4.Size = new Size(220, 68);
            textBox5.Size = new Size(220, 68);

            button6.Location = new Point(814, 39);
            button6.Size = new Size(66, 23);
            label6.Location= new Point(362, 12);
            label6.Size= new Size(83, 12);

            textBox6.Location = new Point(451,9);
            textBox6.Size = new Size(57, 19);
            label7.Location = new Point(514, 12);
            label7.Size = new Size(31, 12);

            Disp0();
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            Width = 1150;
            Height = 770;
        }


        private void button6_Click(object sender, EventArgs e)  //復元
        {
            appendFlg = 0;
            Data_Init();

            timer1.Interval = Convert.ToInt32(textBox6.Text);
            textBox6.Enabled = false;

            timer1.Enabled = false;

            openFileDialog1.FileName = "";
            openFileDialog1.Filter = "テキスト(*.txt)|*.txt|" + "All files(*.*)|*.*";
            if (openFileDialog1.ShowDialog() != DialogResult.OK)
            {
                return;
            }
            string fname = openFileDialog1.FileName;


            string s = File.ReadAllText(fname);
            string[] separator = new string[] { "  ", "\r\n"};
            string[] subs = s.Split(separator, StringSplitOptions.None);

            int count = 0;

            foreach (var sub in subs)
            {
              switch(count)
                {
                    case 0:
                        {
                            Hiniti = sub;

                            
                            count++;
                            break;
                        }
                    case 1:
                        {
                            Ondo = sub;
                            count++;
                            break;
                        }
                    case 2:
                        {
                            Situdo = sub;
                            
                            count++;
                            break;

                        }
                    case 3:
                        {
                            Kiatu = sub;

                            TakeData(255);
                            count = 0;
                            break;

                        }
                }

            }
            timer1.Enabled = true;
            button4.Enabled = true;
            button1.Enabled = false;
           // button5.Enabled = true;
            button6.Enabled = false;
            button5.Text = "新規保存";
        }
        private void Data_Init()
        {
            Ps = Pe = Pg = 0;
            textBox1.Clear();
            textBox3.Clear();
            textBox4.Clear();
            textBox5.Clear();
            Pmin = Tmin = Hmin = 2000;
            Pmax = Tmax = Hmax = 0;
            button6.Enabled = false; //取得間隔
            Disp0();


        }
        private void button5_Click(object sender, EventArgs e)  //Save
        {

            saveFileDialog1.Filter = "テキスト(*.txt)|*.txt|" + "All files(*.*)|*.*";
            saveFileDialog1.OverwritePrompt = false; //上書きの警告なし
            if (saveFileDialog1.ShowDialog() != DialogResult.OK)
            {
                return;
            }
            string fname = saveFileDialog1.FileName;

            if (appendFlg == 255) //上書き
            {
                if (File.Exists(fname) == true)
                {
                    File.AppendAllText(fname, textBox3.Text);
                }
                else
                {
                    File.WriteAllText(fname, textBox3.Text);


                }
            }
            else
            {
                File.WriteAllText(fname, textBox3.Text);
            }
            Data_Init();
            button5.Text = "追記保存";
            appendFlg = 255;
        }

        public bool URLExists(string url)
        {

            int len;
            len = url.Length;
            url = url.Substring(7, len - 7); //192.168.1.171でないとPingでエラ－、ｈｔｔｐ：がつくとエラ－
                                             //wc.DownloadString(textBox2.Text);はｈｔｔｐ：..でないとエラ－

            using (var ping = new System.Net.NetworkInformation.Ping())
            {
                var sendresult = ping.Send(url);
                if (sendresult.Status == IPStatus.Success)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        void TakeData(int flg=0) //run,復元で利用するため　グロ-バルのHiniti, Ondo, Situdo, Kiatu変数が必要
        {
            try
                {
                  if (flg == 0)
                  {
                    WebClient wc = new WebClient();
                    string text = wc.DownloadString(textBox2.Text);
                    DateTime dt = DateTime.Now;
                    Hiniti = dt.ToString();
                    int p = text.IndexOf("Temp");
                    Ondo = text.Substring(p + 5, 5);
                    p = text.IndexOf("Hum");
                    Situdo = text.Substring(p + 4, 5);
                    p = text.IndexOf("Press");
                    Kiatu = text.Substring(p + 6, 6);

                  }
                }
                catch (WebException exc)
                {
                  textBox1.Text += exc.Message;
                }

                textBox1.AppendText(Hiniti);
                WD[Pe].d = Hiniti;
                textBox1.AppendText("  ");

                textBox1.AppendText(" , ");
                textBox1.AppendText(Ondo);
                WD[Pe].temp = Convert.ToSingle(Ondo);
                if(WD[Pe].temp>Tmax)
                {
                    Tmaxtime = WD[Pe].d;
                    Tmax = WD[Pe].temp;
                }
                if (WD[Pe].temp < Tmin)
                {
                    Tmintime = WD[Pe].d;
                    Tmin = WD[Pe].temp;
                }

                textBox1.AppendText(" , ");
                textBox1.AppendText(Situdo);
                WD[Pe].hum = Convert.ToSingle(Situdo);
                if (WD[Pe].hum > Hmax)
                {
                    Hmaxtime = WD[Pe].d;
                    Hmax = WD[Pe].hum;
                }
                if (WD[Pe].hum < Hmin)
                {
                    Hmintime = WD[Pe].d;
                    Hmin = WD[Pe].hum;
                }

                textBox1.AppendText(" , ");
                textBox1.AppendText(Kiatu);
                textBox1.AppendText("\r\n");
                WD[Pe].press = Convert.ToSingle(Kiatu);

                if (WD[Pe].press > Pmax)
                {
                    Pmaxtime = WD[Pe].d;
                    Pmax = WD[Pe].press;
                }
                if (WD[Pe].press < Pmin)
                {
                    Pmintime = WD[Pe].d;
                    Pmin = WD[Pe].press;
                }

                Pg++;
                if(Pg>10)
                {
                    textBox1.Clear();
                    Pg = 0;
                }

                if (Pe < Ps)
                {
                    Pe++;
                    Ps++;
                    if (Ps > DTotal)
                    {
                        Ps = 0;
                    }

                }
                else
                {
                    Pe++;

                    if (Pe > DTotal)
                    {
                        Pe = 0;
                        Ps++;
                    }
                    else
                    {
                        if (Pe < Ps)
                        {
                            Ps++;
                            Pe++;

                        }
                    }
                }
                label2.Text = Ps.ToString(); //デ－タの保存位置　Debug用
                label3.Text = Pe.ToString();
            }

        private void button1_Click(object sender, EventArgs e)  //RUN
        {
            if (URLExists(textBox2.Text) == false)
            {
                MessageBox.Show("URLが存在しません　！",
                    "エラー",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error);

                return;
            }
            button5.Text = "追記保存";
            button6.Enabled = false;

            Ps = Pe= Pg = 0;
           timer1.Enabled = true;
           button4.Enabled = true;
           //button5.Enabled = true;
　　　　　
           button1.Enabled = false;

           timer1.Interval =Convert.ToInt32(textBox6.Text);
           textBox6.Enabled = false;

           textBox1.AppendText("Started !\r\n");
           appendFlg = 255;  //新たに起動した時は上書きSave
           Pmax = Tmax = Hmax = 0;
           Pmin = Tmin = Hmin =2000;
           TakeData();
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            TakeData();
        }

        void DispGrh(int i)
        {
            pictureBox1.Image = canvas;

            int pr,ptemp,phum;
            pr = ((int)(WD[i].press) - 1000)*5;

            ptemp = (pictureBox1.Height / 2) - (int)(WD[i].temp-20)*5;
            phum = ((pictureBox1.Height/6)*5) - (int)(WD[i].hum-70)*2;

            Graphics g = Graphics.FromImage(pictureBox1.Image);

            g.FillRectangle(Brushes.Green,Px, (pictureBox1.Height /6)-pr+20, 1, 5);

            g.FillRectangle(Brushes.Red, Px, ptemp , 1, 5);
            g.FillRectangle(Brushes.Blue, Px++, phum, 1, 5);
            g.Dispose();
            pictureBox1.Refresh();

        }
        private String seikei(String s,String s1)
        {
            s = s+s1 + "         ";
            s = s.Substring(0, 25);
            return s;


        }
        void Disp0()
        {
            Px=Px0 = 50;
            canvas = new Bitmap(pictureBox1.Width, pictureBox1.Height);
            Graphics g = Graphics.FromImage(canvas);
            Pen p = new Pen(Color.Black, 1);
            g.DrawLine(p, Px-1, 0, Px-1, pictureBox1.Height);

            p = new Pen(Color.Green, 1);
            g.DrawLine(p, Px-1, pictureBox1.Height/6+20, pictureBox1.Width, pictureBox1.Height / 6+20);
            g.DrawLine(p, Px - 1, pictureBox1.Height / 6 + 20-50, pictureBox1.Width, pictureBox1.Height / 6 + 20-50);

            p = new Pen(Color.Red, 1);
            g.DrawLine(p, Px-1, pictureBox1.Height/2, pictureBox1.Width, pictureBox1.Height/2);
            g.DrawLine(p, Px - 1, pictureBox1.Height / 2-50, pictureBox1.Width, pictureBox1.Height / 2-50);
            g.DrawLine(p, Px - 1, pictureBox1.Height / 2 + 50, pictureBox1.Width, pictureBox1.Height / 2 + 50);

            p = new Pen(Color.Blue, 1);
            g.DrawLine(p, Px-1,( (pictureBox1.Height/6)*5), pictureBox1.Width, (pictureBox1.Height/6)*5);
            g.DrawLine(p, Px - 1, ((pictureBox1.Height / 6) * 5-20), pictureBox1.Width, (pictureBox1.Height / 6) * 5-20);
            g.DrawLine(p, Px - 1, ((pictureBox1.Height / 6) * 5+20), pictureBox1.Width, (pictureBox1.Height / 6) * 5+20);

            Font drawFont = new Font("MS UI Gothic",10);
            SolidBrush drawBrush = new SolidBrush(Color.Green);
            g.DrawString("1000hP", drawFont, drawBrush, 0, pictureBox1.Height / 6+10);
            g.DrawString("1010hP", drawFont, drawBrush, 0, pictureBox1.Height / 6 + 10-50);

            drawFont = new Font("メイリオ", 10);
            drawBrush = new SolidBrush(Color.Blue);
            g.DrawString("70 %", drawFont, drawBrush, 0, ((pictureBox1.Height / 6)*5-10));
            g.DrawString("80 %", drawFont, drawBrush, 0, ((pictureBox1.Height / 6) * 5-30));
            g.DrawString("60 %", drawFont, drawBrush, 0, ((pictureBox1.Height / 6) * 5+10));

            drawFont = new Font("Arial", 10);
 
            drawBrush = new SolidBrush(Color.Red);
            g.DrawString("20 ℃", drawFont, drawBrush, 0, pictureBox1.Height/2-10);
            g.DrawString("30 ℃", drawFont, drawBrush, 0, pictureBox1.Height / 2-60);
            g.DrawString("10 ℃", drawFont, drawBrush, 0, pictureBox1.Height / 2 + 40);

            g.Dispose();

            pictureBox1.Image = canvas;
            pictureBox1.Refresh();
         }
        private void button4_Click(object sender, EventArgs e) //DATA Disp
        {
            int i;
            if ((Pe < 1)&&(Ps<1))
            { return; }
            Px = 50;
            textBox3.Clear();
            String s;
            if (Ps < Pe)
            {
                for (i = Ps; i < Pe; i++)
                {
                    textBox3.AppendText(WD[i].d);
                    textBox3.AppendText("  ");
                    
                    s=String.Format("{0:00.00}  ", WD[i].temp);
                    s += String.Format("{0:00.00}  ", WD[i].hum);
                    s += String.Format("{0:0000.00}", WD[i].press);
                    
                    textBox3.AppendText(s);

                    textBox3.AppendText("\r\n");
                    DispGrh(i);


                }
            }
            else
            {
                for (i = Ps; i < DTotal; i++)
                {
                    textBox3.AppendText(WD[i].d);
                    textBox3.AppendText("  ");

                    s = String.Format("{0:00.00}  ", WD[i].temp);
                    s += String.Format("{0:00.00}  ", WD[i].hum);
                    s += String.Format("{0:0000.00}", WD[i].press);

                    textBox3.AppendText(s);

                    textBox3.AppendText("\r\n");
                    DispGrh(i);

                }
                for (i = 0; i < Ps-1; i++)
                {
                    textBox3.AppendText(WD[i].d);
                    textBox3.AppendText("  ");

                    s = String.Format("{0:00.00}  ", WD[i].temp);
                    s += String.Format("{0:00.00}  ", WD[i].hum);
                    s += String.Format("{0:0000.00}", WD[i].press);

                    textBox3.AppendText(s);

                    textBox3.AppendText("\r\n");

                    DispGrh(i);
                }
            }
            textBox4.Clear();
            textBox5.Clear();

            s = seikei("気圧  ",Pmaxtime);
            textBox4.AppendText(s);

            s = String.Format("{0: .00}", Pmax);
            textBox4.AppendText(s);
            textBox4.AppendText("\r\n");


            s=seikei("気圧  ",Pmintime);
            textBox5.AppendText(s);

            s = String.Format("{0: .00}", Pmin);
            textBox5.AppendText(s);
            textBox5.AppendText("\r\n");


            s = seikei("温度  ",Tmaxtime);
            textBox4.AppendText(s);
            s = String.Format("{0:  .00}", Tmax);
            textBox4.AppendText(s);
            textBox4.AppendText("\r\n");

            s = seikei("温度  ",Tmintime);
            textBox5.AppendText(s);
 
            s = String.Format("{0:  .00}", Tmin);
            textBox5.AppendText(s);
            textBox5.AppendText("\r\n");

            s = seikei("湿度  ",Hmaxtime);
            textBox4.AppendText(s);

            s = String.Format("{0:  .00}", Hmax);
            textBox4.AppendText(s);
            textBox4.AppendText("\r\n");

            s = seikei("湿度  ",Hmintime);
            textBox5.AppendText(s);

            s = String.Format("{0:  .00}", Hmin);
            textBox5.AppendText(s);
            textBox5.AppendText("\r\n");
 
            button5.Enabled = true;
        }

        private void button2_Click(object sender, EventArgs e)  //Close
        {
            Close();
        }
    }
}
