unit Unit1;

interface

uses
  System.SysUtils, System.Types, System.UITypes, System.Classes, System.Variants,
  FMX.Types, FMX.Controls, FMX.Forms, FMX.Graphics, FMX.Dialogs, FMX.Menus,
  FMX.Layouts, FMX.ExtCtrls, FMX.Controls.Presentation, FMX.StdCtrls;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    MenuItem1: TMenuItem;
    MenuItem2: TMenuItem;
    MenuItem3: TMenuItem;
    MenuItem4: TMenuItem;
    MenuItem5: TMenuItem;
    MenuItem6: TMenuItem;
    ImageViewer1: TImageViewer;
    Panel1: TPanel;
    Label2: TLabel;
    Label3: TLabel;
    Label1: TLabel;
    MenuItem9: TMenuItem;
    MenuItem10: TMenuItem;
    MenuItem11: TMenuItem;
    procedure MenuItem2Click(Sender: TObject);
    procedure MenuItem4Click(Sender: TObject);
    procedure MenuItem3Click(Sender: TObject);
    procedure MenuItem6Click(Sender: TObject);
 //   procedure Label1MouseWheel(Sender: TObject; Shift: TShiftState;
 //     WheelDelta: Integer; var Handled: Boolean);
    procedure ImageViewer1MouseWheel(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; var Handled: Boolean);
    procedure ImageViewer1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single);
    procedure ImageViewer1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Single);
    procedure ImageViewer1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Single);
    procedure MenuItem9Click(Sender: TObject);
    procedure MenuItem11Click(Sender: TObject);

  private
    { private 錾 }
  public
    { public 錾 }
  end;

var
  Form1: TForm1;

implementation

{$R *.fmx}
uses
 FMX.Clipboard,FMX.Platform,System.IOUtils;
var X0,Y0 :Single;
var DFlg :Integer;

function takefilename(): string;  //File Namȅ
begin
var ext :string;
var path :string;
var path1 :string;


if Form1.SaveDialog1.Execute then
 ext :=LowerCase(TPath.GetExtension(Form1.SaveDialog1.FileName));
 path := TPath.GetFileNameWithoutExtension(Form1.SaveDialog1.FileName);
 path1 :=ExtractFilePath(Form1.SaveDialog1.FileName);
 if (ext='') then begin
    Form1.SaveDialog1.FileName :=Form1.SaveDialog1.FileName+'.jpg';
 end
 else
 if (ext<>'.jpg')and(ext<>'.bmp')and(ext<>'.png') then
   Form1.SaveDialog1.FileName :=path1+path+'.jpg';

 if(path='')  then
    Form1.SaveDialog1.FileName :='';

 Result :=  Form1.SaveDialog1.FileName;  //ResultϐAԂl

end;

//}EX̃hbOŉ摜̈ʒu𓮂
procedure TForm1.ImageViewer1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Single);
begin
if ssLeft in Shift then  begin  //{^Ȃ
 X0 :=X;
 Y0 :=Y;
 DFlg :=255;
end;
end;

procedure TForm1.ImageViewer1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Single);
begin
var x2 :Single;
var y2 :Single;

if DFlg =255 then begin
  x2 :=X-X0;
  Y2 :=Y-Y0;
  ImageViewer1.ScrollBy(x2,y2);
  x0 :=X;
  Y0 :=Y;
  end;

end;

procedure TForm1.ImageViewer1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Single);
begin
 DFlg :=0;
end;

procedure TForm1.ImageViewer1MouseWheel(Sender: TObject; Shift: TShiftState;
  WheelDelta: Integer; var Handled: Boolean);
begin
  var  i: Single;
   i := ImageViewer1.BitmapScale ;
  var s :string;

   s :=FloatToStr(i);
   s := Copy(s,1,5);   //\Sɂ

   label1.Text :=s;     //g嗦̕\
end;

procedure TForm1.MenuItem2Click(Sender: TObject);  //File Open
begin
if OpenDialog1.Execute then
 ImageViewer1.Bitmap.LoadfromFile(OpenDialog1.FileName);
 label3.Text := OpenDialog1.FileName;

end;

procedure TForm1.MenuItem3Click(Sender: TObject); //ClipBoardǂݍ݁@
begin
 var Clipboard: IFMXExtendedClipboardService;

if
 not TPlatformServices.Current.SupportsPlatformService(IFMXExtendedClipboardService, Clipboard)

then
 exit;

if Clipboard.HasImage then
 ImageViewer1.Bitmap.Assign(Clipboard.GetImage);
 label3.Text := 'ClipBoard';
end;

procedure TForm1.MenuItem4Click(Sender: TObject);  //file  ۑ
begin
var fname :string;

 fname := takefilename();
 if(fname<>'') then
    ImageViewer1.Bitmap.SaveToFile(fname);

end;

procedure TForm1.MenuItem6Click(Sender: TObject);
begin
 Close;
end;

procedure TForm1.MenuItem9Click(Sender: TObject);   //screen ۑ
begin
 var bmp :TBitmap;
 var fname :string;
 bmp :=TBitMap.Create();

 fname := takefilename();

 if(fname<>'') then
   ImageViewer1.ShowScrollBars :=false;

   bmp :=ImageViewer1.MakeScreenshot();

   bmp.SaveToFile(fname);

   bmp.Free;

   ImageViewer1.ShowScrollBars :=true;
{*
ImageViewer1.Bitmap :=ImageViewer1.MakeScreenshot();
ImageViewer1.Bitmap.SaveToFile('D:\SCREEN.JPG');
*}
end;

procedure TForm1.MenuItem11Click(Sender: TObject);  //Screen->Clipbord
var
  VClipboard: IFMXClipboardService;
var bmp :TBitmap;

begin
   if TPlatformServices.Current.SupportsPlatformService(IFMXClipboardService, VClipboard) then begin
    ImageViewer1.ShowScrollBars :=false;

    bmp :=ImageViewer1.MakeScreenshot();
    VClipboard.SetClipboard(bmp);

 //   VClipboard.SetClipboard(ImageViewer1.Bitmap);
 //   VClipboard.SetClipboard(ImageViewer1.Bitmap);

    ImageViewer1.ShowScrollBars :=true;

    bmp.Free;
end;
end;
end.
